<?php

/*

* 2007-2013 PrestaShop

*

* NOTICE OF LICENSE

*

* This source file is subject to the Academic Free License (AFL 3.0)

* that is bundled with this package in the file LICENSE.txt.

* It is also available through the world-wide-web at this URL:

* http://opensource.org/licenses/afl-3.0.php

* If you did not receive a copy of the license and are unable to

* obtain it through the world-wide-web, please send an email

* to license@prestashop.com so we can send you a copy immediately.

*

* DISCLAIMER

*

* Do not edit or add to this file if you wish to upgrade PrestaShop to newer

* versions in the future. If you wish to customize PrestaShop for your

* needs please refer to http://www.prestashop.com for more information.

*

*  @author PrestaShop SA <contact@prestashop.com>

*  @copyright  2007-2013 PrestaShop SA

*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

*  International Registered Trademark & Property of PrestaShop SA

*/



if (!defined('_PS_VERSION_'))

	exit;



class Omicronadvt extends Module

{

	/* Title associated to the image */

	public $omicronadv_title;

	

	public $omicronadv_subtitle;

	

	public $omicronadv_content;

	

	/* Link associated to the image */

	public $omicronadv_link;

	

	/* Name of the image without extension */

	public $omicronadv_imgname;

	

	/* Image path with extension */

	public $omicronadv_img;

	

	

	/* Title associated to the image */

	public $omicronadv_title2;

	

	public $omicronadv_subtitle2;

	

	public $omicronadv_content2;

	

	/* Link associated to the image */

	public $omicronadv_link2;

	

	/* Name of the image without extension */

	public $omicronadv_imgname2;

	

	/* Image path with extension */

	public $omicronadv_img2;

	

	

	

	/* Title associated to the image */

	public $omicronadv_title3;

	

	public $omicronadv_subtitle3;

	

	public $omicronadv_content3;

	

	/* Link associated to the image */

	public $omicronadv_link3;

	

	/* Name of the image without extension */

	public $omicronadv_imgname3;

	

	/* Image path with extension */

	public $omicronadv_img3;



	public function __construct()

	{

		$this->name = 'omicronadvt';

		$this->tab = 'advertising_marketing';

		$this->version = '0.5';

		$this->author = 'DigitalOmicron';

		$this->need_instance = 0;



		parent::__construct();



		$this->displayName = $this->l('Omicron advertising');

		$this->description = $this->l('Adds an advertisement block to selected sections of your e-commerce webiste.');

		

		$this->initialize();

	}



	/*

	 * Set the properties of the module, like the link to the image and the title (contextual to the current shop context)

	 */

	protected function initialize()

	{

		/*

	 * First block image

	 */

		$this->omicronadv_imgname = 'omicronadvertising';

		if ((Shop::getContext() == Shop::CONTEXT_GROUP  || Shop::getContext() == Shop::CONTEXT_SHOP)

			&& file_exists(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname.'-g'.$this->context->shop->getContextShopGroupID().'.'.Configuration::get('OMICRONADVERT_IMG_EXT')))

			$this->omicronadv_imgname .= '-g'.$this->context->shop->getContextShopGroupID();

		if (Shop::getContext() == Shop::CONTEXT_SHOP

			&& file_exists(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname.'-s'.$this->context->shop->getContextShopID().'.'.Configuration::get('OMICRONADVERT_IMG_EXT')))

			$this->omicronadv_imgname .= '-s'.$this->context->shop->getContextShopID();



		$this->omicronadv_img = Tools::getMediaServer($this->name)._MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname.'.'.Configuration::get('OMICRONADVERT_IMG_EXT');

		$this->omicronadv_link = htmlentities(Configuration::get('OMICRONADVERT_LINK'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_title = htmlentities(Configuration::get('OMICRONADVERT_TITLE'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_subtitle = htmlentities(Configuration::get('OMICRONADVERT_SUBTITLE'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_content = htmlentities(Configuration::get('OMICRONADVERT_CONTENT'), ENT_QUOTES, 'UTF-8');

		

	/*

	 * Second block image

	 */	

		

		$this->omicronadv_imgname2 = 'omicronadvertising2';

		if ((Shop::getContext() == Shop::CONTEXT_GROUP  || Shop::getContext() == Shop::CONTEXT_SHOP)

			&& file_exists(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname2.'-g'.$this->context->shop->getContextShopGroupID().'.'.Configuration::get('OMICRONADVERT_IMG_EXT')))

			$this->omicronadv_imgname2 .= '-g'.$this->context->shop->getContextShopGroupID();

		if (Shop::getContext() == Shop::CONTEXT_SHOP

			&& file_exists(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname2.'-s'.$this->context->shop->getContextShopID().'.'.Configuration::get('OMICRONADVERT_IMG_EXT')))

			$this->omicronadv_imgname2 .= '-s'.$this->context->shop->getContextShopID();



		$this->omicronadv_img2 = Tools::getMediaServer($this->name)._MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname2.'.'.Configuration::get('OMICRONADVERT_IMG_EXT');

		$this->omicronadv_link2 = htmlentities(Configuration::get('OMICRONADVERT_LINK2'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_title2 = htmlentities(Configuration::get('OMICRONADVERT_TITLE2'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_subtitle2 = htmlentities(Configuration::get('OMICRONADVERT_SUBTITLE2'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_content2 = htmlentities(Configuration::get('OMICRONADVERT_CONTENT2'), ENT_QUOTES, 'UTF-8');

		

		

		

		/*

	 * Third block image

	 */	

		

		$this->omicronadv_imgname3 = 'omicronadvertising3';

		if ((Shop::getContext() == Shop::CONTEXT_GROUP  || Shop::getContext() == Shop::CONTEXT_SHOP)

			&& file_exists(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname3.'-g'.$this->context->shop->getContextShopGroupID().'.'.Configuration::get('OMICRONADVERT_IMG_EXT')))

			$this->omicronadv_imgname3 .= '-g'.$this->context->shop->getContextShopGroupID();

		if (Shop::getContext() == Shop::CONTEXT_SHOP

			&& file_exists(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname3.'-s'.$this->context->shop->getContextShopID().'.'.Configuration::get('OMICRONADVERT_IMG_EXT')))

			$this->omicronadv_imgname3 .= '-s'.$this->context->shop->getContextShopID();



		$this->omicronadv_img3 = Tools::getMediaServer($this->name)._MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname3.'.'.Configuration::get('OMICRONADVERT_IMG_EXT');

		$this->omicronadv_link3 = htmlentities(Configuration::get('OMICRONADVERT_LINK3'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_title3 = htmlentities(Configuration::get('OMICRONADVERT_TITLE3'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_subtitle3 = htmlentities(Configuration::get('OMICRONADVERT_SUBTITLE3'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_content3 = htmlentities(Configuration::get('OMICRONADVERT_CONTENT3'), ENT_QUOTES, 'UTF-8');

	}

	

	public function install()

	{

		/*

	 * First block image

	 */

		Configuration::updateGlobalValue('OMICRONADVERT_LINK', 'http://www.prestashop.com/');

		Configuration::updateGlobalValue('OMICRONADVERT_TITLE', 'Beats by dr.dre');

		Configuration::updateGlobalValue('OMICRONADVERT_SUBTITLE', 'get up to 40% off');

		

		Configuration::updateGlobalValue('OMICRONADVERT_CONTENT', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.');

		// Try to update with the extension of the image that exists in the module directory

		foreach (scandir(_PS_MODULE_DIR_.$this->name) as $file)

			if (in_array($file, array('omicronadvertising-s1.jpg', 'omicronadvertising-s1.jpeg',  'omicronadvertising-s1.gif', 'omicronadvertising-s1.png')))

				Configuration::updateGlobalValue('OMICRONADVERT_IMG_EXT', substr($file, strrpos($file, '.') + 1));

				

		/*

	 * Second block image

	 */		

		Configuration::updateGlobalValue('OMICRONADVERT_LINK2', 'http://www.prestashop.com/');

		Configuration::updateGlobalValue('OMICRONADVERT_TITLE2', 'Enjoy with HTC');

		Configuration::updateGlobalValue('OMICRONADVERT_SUBTITLE2', 'HTC one - Free Shipping');

		Configuration::updateGlobalValue('OMICRONADVERT_CONTENT2', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.');

		// Try to update with the extension of the image that exists in the module directory

		foreach (scandir(_PS_MODULE_DIR_.$this->name) as $file)

			if (in_array($file, array('omicronadvertising2-s1.jpg', 'omicronadvertising2-s1.jpeg',  'omicronadvertising2-s1.gif', 'omicronadvertising2-s1.png')))

				Configuration::updateGlobalValue('OMICRONADVERT_IMG_EXT', substr($file, strrpos($file, '.') + 1));

				

				

	/*

	 * Third block image

	 */		

		Configuration::updateGlobalValue('OMICRONADVERT_LINK3', 'http://www.prestashop.com/');

		Configuration::updateGlobalValue('OMICRONADVERT_TITLE3', 'Today offer');

		Configuration::updateGlobalValue('OMICRONADVERT_SUBTITLE3', 'All camera lenses 25% off');

		Configuration::updateGlobalValue('OMICRONADVERT_CONTENT3', 'Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.');

		// Try to update with the extension of the image that exists in the module directory

		foreach (scandir(_PS_MODULE_DIR_.$this->name) as $file)

			if (in_array($file, array('omicronadvertising3-s1.jpg', 'omicronadvertising3-s1.jpeg',  'omicronadvertising3-s1.gif', 'omicronadvertising3-s1.png')))

				Configuration::updateGlobalValue('OMICRONADVERT_IMG_EXT', substr($file, strrpos($file, '.') + 1));

				



		return (parent::install() && $this->registerHook('header') && $this->registerHook('home'));

	}

	

	public function uninstall()

	{

		Configuration::deleteByName('OMICRONADVERT_LINK');

		Configuration::deleteByName('OMICRONADVERT_TITLE');

		Configuration::deleteByName('OMICRONADVERT_SUBTITLE');

		Configuration::deleteByName('OMICRONADVERT_IMG_EXT');

		

		Configuration::deleteByName('OMICRONADVERT_LINK2');

		Configuration::deleteByName('OMICRONADVERT_TITLE2');

		Configuration::deleteByName('OMICRONADVERT_SUBTITLE2');

		Configuration::deleteByName('OMICRONADVERT_IMG_EXT');

		

		Configuration::deleteByName('OMICRONADVERT_LINK3');

		Configuration::deleteByName('OMICRONADVERT_TITLE3');

		Configuration::deleteByName('OMICRONADVERT_SUBTITLE3');

		Configuration::deleteByName('OMICRONADVERT_IMG_EXT');

		return (parent::uninstall());

	}



	/**

	 * delete the contextual image (it is not allowed to delete the default image)

	 *

	 * @return void

	 */

	private function _deleteCurrentImg()

	{

		// Delete the image file

		if ($this->omicronadv_imgname != 'omicronadvertising' && file_exists(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname.'.'.Configuration::get('OMICRONADVERT_IMG_EXT')))

			unlink(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname.'.'.Configuration::get('OMICRONADVERT_IMG_EXT'));

		

		// Update the extension to the global value or the shop group value if available

		Configuration::deleteFromContext('OMICRONADVERT_IMG_EXT');

		Configuration::updateValue('OMICRONADVERT_IMG_EXT', Configuration::get('OMICRONADVERT_IMG_EXT'));

		

	}

	private function _deleteCurrentImg2()

	{

		// Delete the image file

		if ($this->omicronadv_imgname2 != 'omicronadvertising2' && file_exists(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname2.'.'.Configuration::get('OMICRONADVERT_IMG_EXT2')))

			unlink(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname2.'.'.Configuration::get('OMICRONADVERT_IMG_EXT2'));

		

		// Update the extension to the global value or the shop group value if available

		Configuration::deleteFromContext('OMICRONADVERT_IMG_EXT2');

		Configuration::updateValue('OMICRONADVERT_IMG_EXT2', Configuration::get('OMICRONADVERT_IMG_EXT2'));



		// Reset the properties of the module

		$this->initialize();

	}

	

	private function _deleteCurrentImg3()

	{

		// Delete the image file

		if ($this->omicronadv_imgname3 != 'omicronadvertising3' && file_exists(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname3.'.'.Configuration::get('OMICRONADVERT_IMG_EXT3')))

			unlink(_PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname3.'.'.Configuration::get('OMICRONADVERT_IMG_EXT3'));

		

		// Update the extension to the global value or the shop group value if available

		Configuration::deleteFromContext('OMICRONADVERT_IMG_EXT3');

		Configuration::updateValue('OMICRONADVERT_IMG_EXT3', Configuration::get('OMICRONADVERT_IMG_EXT3'));



		// Reset the properties of the module

		$this->initialize();

	}



	public function postProcess()

	{

		if (Tools::isSubmit('submitDeleteImgConf'))

			$this->_deleteCurrentImg();

			

		if (Tools::isSubmit('submitDeleteImgConf2'))

			$this->_deleteCurrentImg2();

			

		if (Tools::isSubmit('submitDeleteImgConf3'))

			$this->_deleteCurrentImg3();



		$errors = '';

		if (Tools::isSubmit('submitAdvConf'))

		{

			if (isset($_FILES['omicronadv_img']) && isset($_FILES['omicronadv_img']['tmp_name']) && !empty($_FILES['omicronadv_img']['tmp_name']))

			{

				if ($error = ImageManager::validateUpload($_FILES['omicronadv_img'], Tools::convertBytes(ini_get('upload_max_filesize'))))

					$errors .= $error;

				else

				{

					Configuration::updateValue('OMICRONADVERT_IMG_EXT', substr($_FILES['omicronadv_img']['name'], strrpos($_FILES['omicronadv_img']['name'], '.') + 1));



					// Set the image name with a name contextual to the shop context

					$this->omicronadv_imgname = 'omicronadvertising';

					if (Shop::getContext() == Shop::CONTEXT_GROUP)

						$this->omicronadv_imgname = 'omicronadvertising'.'-g'.(int)$this->context->shop->getContextShopGroupID();

					elseif (Shop::getContext() == Shop::CONTEXT_SHOP)

						$this->omicronadv_imgname = 'omicronadvertising'.'-s'.(int)$this->context->shop->getContextShopID();



					// Copy the image in the module directory with its new name

					if (!move_uploaded_file($_FILES['omicronadv_img']['tmp_name'], _PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname.'.'.Configuration::get('OMICRONADVERT_IMG_EXT')))

						$errors .= $this->l('File upload error.');

				}

			}

			

			

			

			if (isset($_FILES['omicronadv_img2']) && isset($_FILES['omicronadv_img2']['tmp_name']) && !empty($_FILES['omicronadv_img2']['tmp_name']))

			{

				if ($error = ImageManager::validateUpload($_FILES['omicronadv_img2'], Tools::convertBytes(ini_get('upload_max_filesize'))))

					$errors .= $error;

				else

				{

					Configuration::updateValue('OMICRONADVERT_IMG_EXT2', substr($_FILES['omicronadv_img2']['name'], strrpos($_FILES['omicronadv_img2']['name'], '.') + 1));



					// Set the image name with a name contextual to the shop context

					$this->omicronadv_imgname2 = 'omicronadvertising2';

					if (Shop::getContext() == Shop::CONTEXT_GROUP)

						$this->omicronadv_imgname2 = 'omicronadvertising2'.'-g'.(int)$this->context->shop->getContextShopGroupID();

					elseif (Shop::getContext() == Shop::CONTEXT_SHOP)

						$this->omicronadv_imgname2 = 'omicronadvertising2'.'-s'.(int)$this->context->shop->getContextShopID();



					// Copy the image in the module directory with its new name

					if (!move_uploaded_file($_FILES['omicronadv_img2']['tmp_name'], _PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname2.'.'.Configuration::get('OMICRONADVERT_IMG_EXT2')))

						$errors .= $this->l('File upload error.');

				}

			}

			

			

			if (isset($_FILES['omicronadv_img3']) && isset($_FILES['omicronadv_img3']['tmp_name']) && !empty($_FILES['omicronadv_img3']['tmp_name']))

			{

				if ($error = ImageManager::validateUpload($_FILES['omicronadv_img3'], Tools::convertBytes(ini_get('upload_max_filesize'))))

					$errors .= $error;

				else

				{

					Configuration::updateValue('OMICRONADVERT_IMG_EXT3', substr($_FILES['omicronadv_img3']['name'], strrpos($_FILES['omicronadv_img3']['name'], '.') + 1));



					// Set the image name with a name contextual to the shop context

					$this->omicronadv_imgname3 = 'omicronadvertising3';

					if (Shop::getContext() == Shop::CONTEXT_GROUP)

						$this->omicronomicronadv_imgname3 = 'omicronadvertising3'.'-g'.(int)$this->context->shop->getContextShopGroupID();

					elseif (Shop::getContext() == Shop::CONTEXT_SHOP)

						$this->omicronadv_imgname3 = 'omicronadvertising3'.'-s'.(int)$this->context->shop->getContextShopID();



					// Copy the image in the module directory with its new name

					if (!move_uploaded_file($_FILES['omicronadv_img3']['tmp_name'], _PS_MODULE_DIR_.$this->name.'/'.$this->omicronadv_imgname3.'.'.Configuration::get('OMICRONADVERT_IMG_EXT3')))

						$errors .= $this->l('File upload error.');

				}

			}

			

			// If the link is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($link = Tools::getValue('omicronadv_link'))

				Configuration::updateValue('OMICRONADVERT_LINK', $link);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_LINK');

				

				

				// If the link is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($link2 = Tools::getValue('omicronadv_link2'))

				Configuration::updateValue('OMICRONADVERT_LINK2', $link2);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_LINK2');

				

				

			// If the link is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($link3 = Tools::getValue('omicronadv_link3'))

				Configuration::updateValue('OMICRONADVERT_LINK3', $link3);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_LINK3');

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($title = Tools::getValue('omicronadv_title'))

				Configuration::updateValue('OMICRONADVERT_TITLE', $title);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_TITLE');

				

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($title2 = Tools::getValue('omicronadv_title2'))

				Configuration::updateValue('OMICRONADVERT_TITLE2', $title2);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_TITLE2');

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($title3 = Tools::getValue('omicronadv_title3'))

				Configuration::updateValue('OMICRONADVERT_TITLE3', $title3);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_TITLE3');

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($subtitle = Tools::getValue('omicronadv_subtitle'))

				Configuration::updateValue('OMICRONADVERT_SUBTITLE', $subtitle);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_SUBTITLE');

				

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($subtitle2 = Tools::getValue('omicronadv_subtitle2'))

				Configuration::updateValue('OMICRONADVERT_SUBTITLE2', $subtitle2);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_SUBTITLE2');

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($subtitle3 = Tools::getValue('omicronadv_subtitle3'))

				Configuration::updateValue('OMICRONADVERT_SUBTITLE3', $subtitle3);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_SUBTITLE3');

				

				// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($content = Tools::getValue('omicronadv_content'))

				Configuration::updateValue('OMICRONADVERT_CONTENT', $content);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_CONTENT');

				

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($content2 = Tools::getValue('omicronadv_content2'))

				Configuration::updateValue('OMICRONADVERT_CONTENT2', $content2);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_CONTENT2');

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($content3 = Tools::getValue('omicronadv_content3'))

				Configuration::updateValue('OMICRONADVERT_CONTENT3', $content3);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('OMICRONADVERT_CONTENT3');

			

			// Reset the module properties

			$this->initialize();

			$this->_clearCache('omicronadvt.tpl');

		}

		if ($errors)

			echo $this->displayError($errors);

	}



	/**

	 * getContent used to display admin module form

	 *

	 * @return string content

	 */

	public function getContent()

	{

		$this->postProcess();

		$output = '

		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post" enctype="multipart/form-data">

			<fieldset>

				<legend>'.$this->l('Advertising block configuration').'</legend>';

		if ($this->omicronadv_img)

		{

			$output .= '<div style="float:left; width:450px;">

			<a href="'.$this->omicronadv_link.'" target="_blank" title="'.$this->omicronadv_title.'">

				<img src="'.$this->context->link->protocol_content.$this->omicronadv_img.'" alt="'.$this->omicronadv_title.'" title="'.$this->omicronadv_title.'"

					style="width:300px;height:163px;"/>

			</a>';

			

					

			if ($this->omicronadv_imgname == 'omicronadvertising')

				$output .= $this->l('<div style="float:left;">You cannot delete the default image (but you can change it below).</div>');

			else

				$output .= '<input class="button" type="submit" name="submitDeleteImgConf" value="'.$this->l('Delete image').'" style=""/>';

		}

				

		else

			$output .= '<div style="margin-left: 100px;width:163px;">'.$this->l('No image').'</div>';

			

			$output .= '<br/><br/>

			<div style="float:left; width:350px;">

				<label for="omicronadv_img" style="float:left; width:auto;">'.$this->l('Change image').'&nbsp;&nbsp;</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_img" type="file" name="omicronadv_img" />

					<p>'.$this->l('Image will be displayed as 155x163').'</p>

				</div>

				<br class="clear"/>

				<label for="omicronadv_link" style="float:left; width:auto;">'.$this->l('Image link').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_link" type="text" name="omicronadv_link" value="'.$this->omicronadv_link.'" style="width:250px" />

				</div>

				<br class="clear"/>

				<label for="omicronadv_title" style="float:left; width:auto;">'.$this->l('Title').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_title" type="text" name="omicronadv_title" value="'.$this->omicronadv_title.'" style="width:250px" />

				</div>

				<br class="clear"/>

				<label for="omicronadv_subtitle" style="float:left; width:auto;">'.$this->l('Sub Title').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_subtitle" type="text" name="omicronadv_subtitle" value="'.$this->omicronadv_subtitle.'" style="width:250px" />

				</div>

				<label for="omicronadv_content" style="float:left; width:auto;">'.$this->l('Content').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<textarea name="omicronadv_content" cols="40" rows="5" id="omicronadv_content" value="'.$this->omicronadv_content.'">'.$this->omicronadv_content.'</textarea></div></div></div>';

		

		if ($this->omicronadv_img2)

		{

			$output .= '<div style="float:left; width:450px;">

			<a href="'.$this->omicronadv_link2.'" target="_blank" title="'.$this->omicronadv_title2.'">

				<img src="'.$this->context->link->protocol_content.$this->omicronadv_img2.'" alt="'.$this->omicronadv_title2.'" title="'.$this->omicronadv_title2.'"

					style="width:300px;height:163px;"/>

			</a>';

			

					

			if ($this->omicronadv_imgname2 == 'omicronadvertising')

				$output .= $this->l('<div style="float:left;">You cannot delete the default image (but you can change it below).</div>');

			else

				$output .= '<input class="button" type="submit" name="submitDeleteImgConf2" value="'.$this->l('Delete image').'" style=""/>';

		}

		

				

		else

			$output .= '<div style="margin-left: 100px;width:163px;">'.$this->l('No image').'</div>';

			

			$output .= '<br/><br/>

			<div style="float:left; width:350px;">

				<label for="omicronadv_img2" style="float:left; width:auto;">'.$this->l('Change image').'&nbsp;&nbsp;</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_img2" type="file" name="omicronadv_img2" />

					<p>'.$this->l('Image will be displayed as 155x163').'</p>

				</div>

				<br class="clear"/>

				<label for="omicronadv_link2" style="float:left; width:auto;">'.$this->l('Image link').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_link2" type="text" name="omicronadv_link2" value="'.$this->omicronadv_link2.'" style="width:250px" />

				</div>

				<br class="clear"/>

				<label for="omicronadv_title2" style="float:left; width:auto;">'.$this->l('Title').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_title2" type="text" name="omicronadv_title2" value="'.$this->omicronadv_title2.'" style="width:250px" />

				</div>

				<br class="clear"/>

				<label for="omicronadv_subtitle2" style="float:left; width:auto;">'.$this->l('Sub Title').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_subtitle2" type="text" name="omicronadv_subtitle2" value="'.$this->omicronadv_subtitle2.'" style="width:250px" />

				</div>

				<label for="omicronadv_content2" style="float:left; width:auto;">'.$this->l('Content').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<textarea name="omicronadv_content2" cols="40" rows="5" id="omicronadv_content2" value="'.$this->omicronadv_content2.'">'.$this->omicronadv_content2.'</textarea></div></div></div>';

					

					

		

		if ($this->omicronadv_img3)

		{

			$output .= '<div style="float:left; width:450px;">

			<a href="'.$this->omicronadv_link3.'" target="_blank" title="'.$this->omicronadv_title3.'">

				<img src="'.$this->context->link->protocol_content.$this->omicronadv_img3.'" alt="'.$this->omicronadv_title3.'" title="'.$this->omicronadv_title3.'"

					style="width:300px;height:163px;"/>

			</a>';

			

					

			if ($this->omicronadv_imgname3 == 'omicronadvertising')

				$output .= $this->l('<div style="float:left;">You cannot delete the default image (but you can change it below).</div>');

			else

				$output .= '<input class="button" type="submit" name="submitDeleteImgConf3" value="'.$this->l('Delete image').'" style=""/>';

		}

				

		else

			$output .= '<div style="margin-left: 100px;width:163px;">'.$this->l('No image').'</div>';

			

				$output .= '<br/><br/>

				<div style="float:left; width:350px;">

				<label for="omicronadv_img3" style="float:left; width:auto;">'.$this->l('Change image').'&nbsp;&nbsp;</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_img3" type="file" name="omicronadv_img3" />

					<p>'.$this->l('Image will be displayed as 155x163').'</p>

				</div>

				<br class="clear"/>

				<label for="omicronadv_link3" style="float:left; width:auto;">'.$this->l('Image link').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_link3" type="text" name="omicronadv_link3" value="'.$this->omicronadv_link3.'" style="width:250px" />

				</div>

				<br class="clear"/>

				<label for="omicronadv_title3" style="float:left; width:auto;">'.$this->l('Title').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_title3" type="text" name="omicronadv_title3" value="'.$this->omicronadv_title3.'" style="width:250px" />

				</div>

				<br class="clear"/>

				<label for="omicronadv_subtitle3" style="float:left; width:auto;">'.$this->l('Sub Title').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_subtitle3" type="text" name="omicronadv_subtitle3" value="'.$this->omicronadv_subtitle3.'" style="width:250px" />

				</div>

				<label for="omicronadv_content3" style="float:left; width:auto;">'.$this->l('Content').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<textarea name="omicronadv_content3" cols="40" rows="5" id="omicronadv_content3" value="'.$this->omicronadv_content3.'">'.$this->omicronadv_content3.'</textarea>

					

				</div></div></div>

				

				<br class="clear"/>

				<div class="margin-form" style="margin-top:75px;">

					<input class="button" type="submit" name="submitAdvConf" value="'.$this->l('Validate').'"/>

				</div>

				<br class="clear"/>

				

				

				

				

			</fieldset>

		</form>';

		return $output;

	}



	public function hookHome($params)

	{

		if (!$this->isCached('omicronadvt.tpl', $this->getCacheId()))

			$this->smarty->assign(array(

				'omicronimage' => $this->context->link->protocol_content.$this->omicronadv_img,

				'omicronadv_link' => $this->omicronadv_link,

				'omicronadv_title' => $this->omicronadv_title,

				'omicronadv_subtitle' => $this->omicronadv_subtitle,

				'omicronadv_content' => $this->omicronadv_content,

				

				'omicronimage2' => $this->context->link->protocol_content.$this->omicronadv_img2,

				'omicronadv_link2' => $this->omicronadv_link2,

				'omicronadv_title2' => $this->omicronadv_title2,

				'omicronadv_subtitle2' => $this->omicronadv_subtitle2,

				'omicronadv_content2' => $this->omicronadv_content2,

				

				'omicronimage3' => $this->context->link->protocol_content.$this->omicronadv_img3,

				'omicronadv_link3' => $this->omicronadv_link3,

				'omicronadv_title3' => $this->omicronadv_title3,

				'omicronadv_subtitle3' => $this->omicronadv_subtitle3,

				'omicronadv_content3' => $this->omicronadv_content3

			));



		return $this->display(__FILE__, 'omicronadvt.tpl', $this->getCacheId());

	}



	public function hookLeftColumn($params)

	{

		return $this->hookHome($params);

	}



	public function hookHeader($params)

	{

		$this->context->controller->addCSS($this->_path.'omicronadvt.css', 'all');

	}

}